# AI dla biznesu — minimalizuj koszty dzięki głębokiemu Q-learningowi
# Tworzenie mózgu bez dropoutu

# Importowanie bibliotek
from keras.layers import Input, Dense
from keras.models import Model
from keras.optimizers import Adam

# BUDOWANIE MÓZGU 

class Brain(object):
    
    # BUDOWANIE W PEŁNI POŁĄCZONEJ SIECI NEURONOWEJ WEWNĄTRZ METODY INIT
    
    def __init__(self, learning_rate = 0.001, number_actions = 5):
        self.learning_rate = learning_rate
        
        # BUDOWANIE WARSTWY WEJŚCIOWEJ ZŁOŻONEJ ZE STANÓW WEJŚCIOWYCH 
        states = Input(shape = (3,))
        
        # BUDOWANIE W PEŁNI POŁĄCZONYCH UKRYTYCH  WARSTW
        x = Dense(units = 64, activation = 'sigmoid')(states)
        y = Dense(units = 32, activation = 'sigmoid')(x)
        
        # BUDOWANIE WARSTWY WYJŚCIOWEJ, W PEŁNI POŁĄCZONEJ Z OSTATNIĄ UKRYTĄ WARSTWĄ
        q_values = Dense(units = number_actions, activation = 'softmax')(y)
        
        # MONTAŻ PEŁNEJ ARCHITEKTURY WEWNĄTRZ OBIEKTU MODEL 
        self.model = Model(inputs = states, outputs = q_values)
        
        # KOMPILACJA MODELU Z BŁĘDEM ŚREDNIOKWADRATOWYM STRATY I WYBRANYM OPTYMALIZATOREM 
        self.model.compile(loss = 'mse', optimizer = Adam(lr = learning_rate))
